//
//  GSUndoManager.h
//  Glyphs
//
//  Created by Georg Seifert on 19.06.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol GSUndoClientProtocol

- (void)updateChangeCount:(NSDocumentChangeType)changeType;

- (nullable NSDocument *)document;

- (void)stopUpdates;

- (void)startUpdates;

@property BOOL locked;

@property BOOL justLocked;

@property (nonatomic, strong, nullable) NSDate *lastChange;

// needed for control cached interpolation stuff. lastChange is reset on undo so it can’t cover this.
@property (atomic) NSTimeInterval lastOperationInterval;

@end

@interface GSUndoManager : NSUndoManager
@property (atomic, unsafe_unretained, nullable) NSObject<GSUndoClientProtocol> *glyph;
@property (nonatomic) BOOL isRegisteringUndo;
@end
